package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="role", schema="hib")
public class Role extends ReferenceObject {

	private static final int ROLE_ID_REVIEWER = 1;
	private static final int ROLE_ID_ADMINISTRATOR = 2;	//Admin Tool
	private static final int ROLE_ID_SUPER_USER = 3;
	private static final int ROLE_ID_NDS_ADMIN = 4;
	private static final int ROLE_ID_READ_ONLY_STAFF = 5;
	
	
	public static Role REVIEWER;
	public static Role ADMINISTRATOR;	//Admin Tool
	public static Role SUPER_USER;
	public static Role NDS_ADMIN;
	public static Role READ_ONLY_STAFF;


	private static boolean initialized = false;
	
	public static void initialize() {
		if (initialized == true) {
			return;
		}
		
		try {
			REVIEWER = DartObjectFactory.getInstance().getRoleDAO().findById(ROLE_ID_REVIEWER);
			ADMINISTRATOR = DartObjectFactory.getInstance().getRoleDAO().findById(ROLE_ID_ADMINISTRATOR);
			SUPER_USER = DartObjectFactory.getInstance().getRoleDAO().findById(ROLE_ID_SUPER_USER);
			NDS_ADMIN = DartObjectFactory.getInstance().getRoleDAO().findById(ROLE_ID_NDS_ADMIN);
			READ_ONLY_STAFF = DartObjectFactory.getInstance().getRoleDAO().findById(ROLE_ID_READ_ONLY_STAFF);
			
			initialized = true;	//initialized all of the roles			
		}
		catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}		
	}
	
	
	public static List<Role> listAll() {
		return DartObjectFactory.getInstance().getRoleDAO().listAll();
	}
	
	public static Role findById(final int roleId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getRoleDAO().findById(roleId);
	}
	
	
	/**
	 * Returns the "short name", used in the UI
	 * @return
	 */
	public String getShortName() {
		String name = getName();

		switch( id ) {

			case ROLE_ID_REVIEWER:
				return "Reviewer";

			case ROLE_ID_ADMINISTRATOR:		//Admin Tool
				return "Administration Tool";
				
			case ROLE_ID_SUPER_USER:
				return "";					//"Super User"
				
			case ROLE_ID_NDS_ADMIN:
				return "Admin";				//"NDS Admin"
				
			case ROLE_ID_READ_ONLY_STAFF:
				return "Read-only Staff";
		}
		
		return name;
	}


	@Override
	public int hashCode() {
		return id;
	}
	
	// necessary to use (Set<Role>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof Role) == false) {
			return false;
		}
		
		Role rs2 = (Role)obj;
		return rs2.getId() == this.getId();
	}
	
}
